/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.crazyeights;

import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.DrawSlot;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.PlaySlot;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.crazyeights.CrazyEightsMenu;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.sound.ModSounds;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3914;

public class CrazyEightsGame
extends CardGame<CrazyEightsGame> {
    private final GameOption.Number AVAILABLE_DRAWS = new GameOption.Number(3, 1, 5, (class_2561)class_2561.method_43471((String)"rule.charta.available_draws"), (class_2561)class_2561.method_43471((String)"rule.charta.available_draws.description"));
    private final PlaySlot playPile;
    private final DrawSlot drawPile;
    public final GameSlot suits = new GameSlot(this){

        @Override
        public boolean removeAll() {
            return false;
        }
    };
    public boolean isChoosingWild;
    public Suit currentSuit;
    public int drawsLeft = (Integer)this.AVAILABLE_DRAWS.get();

    public CrazyEightsGame(List<CardPlayer> players, CardDeck deck) {
        super(players, deck);
        this.drawPile = this.addSlot(new DrawSlot(this, new LinkedList<Card>(), 47.5f, 62.5f, 0.0f, 0.0f, () -> this.drawsLeft > 0));
        this.playPile = this.addSlot(new PlaySlot(this, new LinkedList<Card>(), 87.5f, 62.5f, 0.0f, 0.0f, this.drawPile));
    }

    @Override
    public GameSlot getPlayerHand(CardPlayer player) {
        return player == this.getCurrentPlayer() && this.isChoosingWild ? this.suits : super.getPlayerHand(player);
    }

    @Override
    protected GameSlot createPlayerHand(CardPlayer player) {
        return new GameSlot(player.hand()){

            @Override
            public void onInsert(CardPlayer player, List<Card> cards) {
                super.onInsert(player, cards);
                if (CrazyEightsGame.this.drawPile.isDraw()) {
                    player.play(null);
                    CrazyEightsGame.this.drawPile.setDraw(false);
                }
            }

            @Override
            public boolean removeAll() {
                return false;
            }
        };
    }

    @Override
    public List<GameOption<?>> getOptions() {
        return List.of(this.AVAILABLE_DRAWS);
    }

    @Override
    public AbstractCardMenu<CrazyEightsGame> createMenu(int containerId, class_1661 playerInventory, class_3218 level, class_2338 pos, CardDeck deck) {
        return new CrazyEightsMenu(containerId, playerInventory, class_3914.method_17392((class_1937)level, (class_2338)pos), deck, this.players.stream().mapToInt(CardPlayer::getId).toArray(), this.getRawOptions());
    }

    @Override
    public Predicate<CardDeck> getDeckPredicate() {
        return deck -> deck.getCards().stream().filter(c -> c.getSuit() == Suit.BLANK || c.getRank() == Rank.BLANK).findAny().isEmpty();
    }

    @Override
    public Predicate<Card> getCardPredicate() {
        return card -> card.getRank() != Rank.JOKER;
    }

    private CardPlayer getNextPlayer() {
        if (this.currentPlayer == null) {
            return this.getPlayers().getFirst();
        }
        int indexOf = this.getPlayers().indexOf(this.currentPlayer);
        return this.getPlayers().get((indexOf + 1) % this.players.size());
    }

    @Override
    public void startGame() {
        this.drawPile.clear();
        this.playPile.clear();
        this.drawPile.addAll(this.gameDeck);
        this.drawPile.shuffle();
        for (Object player : this.players) {
            player.resetPlay();
            this.getPlayerHand((CardPlayer)player).clear();
            this.getCensoredHand((CardPlayer)player).clear();
        }
        for (int i = 0; i < 5; ++i) {
            for (CardPlayer player : this.players) {
                this.scheduledActions.add(() -> {
                    player.playSound(ModSounds.CARD_DRAW);
                    this.dealCards(this.drawPile, player, 1);
                });
                this.scheduledActions.add(() -> {});
            }
        }
        Card last = this.drawPile.removeLast();
        while (last != null && last.getRank() == Rank.EIGHT) {
            this.drawPile.add(last);
            this.drawPile.shuffle();
            last = this.drawPile.removeLast();
        }
        assert (last != null);
        last.flip();
        Card startingCard = last;
        this.scheduledActions.add(() -> {
            this.playPile.addLast(startingCard);
            this.currentSuit = startingCard.getSuit();
        });
        this.currentPlayer = this.getNextPlayer();
        this.isChoosingWild = false;
        this.isGameReady = false;
        this.isGameOver = false;
        this.table((class_2561)class_2561.method_43471((String)"message.charta.game_started"));
        this.table((class_2561)class_2561.method_43469((String)"message.charta.its_player_turn", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
    }

    @Override
    public void runGame() {
        if (!this.isGameReady) {
            return;
        }
        if (this.drawPile.isEmpty()) {
            if (this.playPile.size() > 1) {
                Card lastCard = this.playPile.removeLast();
                this.playPile.forEach(Card::flip);
                this.drawPile.addAll(this.playPile);
                this.drawPile.shuffle();
                this.playPile.clear();
                this.playPile.add(lastCard);
                this.table((class_2561)class_2561.method_43471((String)"message.charta.piles_shuffled"));
            } else {
                this.endGame();
            }
        }
        this.currentPlayer.afterPlay(play -> {
            this.currentPlayer.resetPlay();
            if (play == null) {
                if (this.drawsLeft > 0) {
                    --this.drawsLeft;
                    this.play(this.currentPlayer, (class_2561)class_2561.method_43471((String)"message.charta.drew_a_card"));
                    if (this.currentPlayer.shouldCompute()) {
                        this.dealCards(this.drawPile, this.currentPlayer, 1);
                        this.currentPlayer.playSound(ModSounds.CARD_DRAW);
                    }
                    if (this.drawsLeft == 0 && this.getBestPlay(this.currentPlayer) == null) {
                        this.nextPlayerAndRunGame();
                    } else {
                        this.runGame();
                    }
                } else {
                    this.nextPlayerAndRunGame();
                }
            } else if (!this.currentPlayer.shouldCompute() || this.canPlay(this.currentPlayer, (CardPlay)play)) {
                Card card = play.cards().getLast();
                this.currentPlayer.playSound(ModSounds.CARD_PLAY);
                this.currentSuit = card.getSuit();
                if (this.isChoosingWild) {
                    this.play(this.currentPlayer, (class_2561)class_2561.method_43469((String)"message.charta.chose_a_suit", (Object[])new Object[]{class_2561.method_43471((String)this.deck.getSuitTranslatableKey(this.currentSuit)).method_54663(this.deck.getSuitColor(this.currentSuit))}));
                    if (!this.currentPlayer.shouldCompute()) {
                        this.playPile.removeLast();
                    }
                    this.isChoosingWild = false;
                } else {
                    this.play(this.currentPlayer, (class_2561)class_2561.method_43469((String)"message.charta.played_a_card", (Object[])new Object[]{class_2561.method_43471((String)this.deck.getCardTranslatableKey(card)).method_54663(this.deck.getCardColor(card))}));
                }
                if (this.currentPlayer.shouldCompute() && this.getPlayerHand(this.currentPlayer).remove(card)) {
                    this.getCensoredHand(this.currentPlayer).removeLast();
                    this.playPile.addLast(card);
                }
                if (this.getFullHand(this.currentPlayer).findAny().isEmpty()) {
                    this.endGame();
                } else if (card.getRank() == Rank.EIGHT) {
                    if (this.currentPlayer.shouldCompute()) {
                        this.currentSuit = this.getMostFrequentSuit(this.currentPlayer);
                        this.play(this.currentPlayer, (class_2561)class_2561.method_43469((String)"message.charta.chose_a_suit", (Object[])new Object[]{class_2561.method_43471((String)this.deck.getSuitTranslatableKey(this.currentSuit))}));
                        this.nextPlayerAndRunGame();
                    } else {
                        this.isChoosingWild = true;
                        this.suits.clear();
                        this.suits.addAll(this.gameSuits.stream().map(s -> new Card((Suit)((Object)((Object)s)), Rank.BLANK)).toList());
                        this.drawsLeft = 0;
                        this.runGame();
                    }
                } else {
                    this.nextPlayerAndRunGame();
                }
            }
        });
    }

    public void nextPlayerAndRunGame() {
        this.drawsLeft = (Integer)this.AVAILABLE_DRAWS.get();
        this.currentPlayer = this.getNextPlayer();
        this.table((class_2561)class_2561.method_43469((String)"message.charta.its_player_turn", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
        this.runGame();
    }

    @Override
    public void endGame() {
        if (this.getFullHand(this.currentPlayer).findAny().isEmpty()) {
            this.currentPlayer.sendTitle((class_2561)class_2561.method_43471((String)"message.charta.you_won").method_27692(class_124.field_1060), (class_2561)class_2561.method_43471((String)"message.charta.congratulations"));
            this.getPlayers().stream().filter(player -> player != this.currentPlayer).forEach(player -> player.sendTitle((class_2561)class_2561.method_43471((String)"message.charta.you_lost").method_27692(class_124.field_1061), (class_2561)class_2561.method_43469((String)"message.charta.won_the_match", (Object[])new Object[]{this.currentPlayer.getName()})));
        } else {
            this.getPlayers().forEach(player -> {
                player.sendTitle((class_2561)class_2561.method_43471((String)"message.charta.draw").method_27692(class_124.field_1054), (class_2561)class_2561.method_43471((String)"message.charta.no_winner"));
                player.sendMessage((class_2561)class_2561.method_43471((String)"message.charta.match_unable").method_27692(class_124.field_1065));
            });
        }
        this.isGameOver = true;
    }

    @Override
    public boolean canPlay(CardPlayer player, CardPlay play) {
        List<Card> cards = play.cards();
        if (cards.size() != 1) {
            return false;
        }
        Card card = cards.getLast();
        Card lastCard = this.playPile.getLast();
        return this.isGameReady && lastCard != null && (this.isChoosingWild && card.getRank() == Rank.BLANK || card.getRank() == Rank.EIGHT || card.getRank() == lastCard.getRank() || card.getSuit() == this.currentSuit);
    }
}

